/**
 * Beschrijft een indiaanpersonage van een computergame.
 * 
 * @author Dominiek Vandewalle
 * @version 2016-04-12
 */
public class Indiaan implements Strijder
{
    private int aantalLevens;
    private String naam;

    /**
     * Constructor voor objecten van de klasse Indiaan.
     * @param   naam    De naam van de indiaan.
     */
    public Indiaan(String naam)
    {
        this.naam = naam;
        aantalLevens = MAXIMUMLEVENS;
    }
    
    /**
     * Constructor voor objecten van de klasse Indiaan.
     * @param   naam    De naam van de indiaan.
     */
    public void schiet(Strijder tegenstander)
    {
        if(aantalLevens > 0)
        {
            tegenstander.geraakt();
        }
    }
    
    /**
     * Vermindert de gezonheidstoestand van de indiaan.
     */
    public void geraakt()
    { 
        if(aantalLevens > 0)
        {
            aantalLevens--;
        }
    }
    
    /**
     * Het roken van een vredespijp met een andere strijder levert een extra leven op.
     * @param   strijder    De strijder waarmee een vredespijp gerookt wordt.
     */
    public void rookVredesPijp(Strijder strijder)
    {
        if(strijder != null)
        {
            aantalLevens++;
        }
    }
    
    /**
     * Toont de gezondheidsstatus van de indiaan in het terminalvenster.
     */
    public void printInfo()
    {
        System.out.println("Naam: " + naam);
        System.out.println("Levens: " + aantalLevens);
    }
}
 